typedef unsigned char cfg_u8;
typedef union {
    struct {
        cfg_u8 offset;
        cfg_u8 value;
    };
    struct {
        cfg_u8 command;
        cfg_u8 param;
    };
} cfg_reg;

#define CFG_META_SWITCH (255)
#define CFG_META_DELAY  (254)
#define CFG_META_BURST  (253)

/* Example C code */
/*
    // Externally implemented function that can write n-bytes to the device
    // PCM51xx and TAS5766 targets require the high bit (0x80) of the I2C register to be set on multiple writes.
    // Refer to the device data sheet for more information.
    extern int i2c_write(unsigned char *data, int n);
    // Externally implemented function that delays execution by n milliseconds
    extern int delay(int n);
    // Example implementation.  Call like:
    //     transmit_registers(registers, sizeof(registers)/sizeof(registers[0]));
    void transmit_registers(cfg_reg *r, int n)
    {
        int i = 0;
        while (i < n) {
            switch (r[i].command) {
            case CFG_META_SWITCH:
                // Used in legacy applications.  Ignored here.
                break;
            case CFG_META_DELAY:
                delay(r[i].param);
                break;
            case CFG_META_BURST:
                i2c_write((unsigned char *)&r[i+1], r[i].param);
                i += (r[i].param + 1)/2;
                break;
            default:
                i2c_write((unsigned char *)&r[i], 2);
                break;
            }
            i++;
        }
    }
 */

cfg_reg registers[] = {
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Sleep
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Sleep
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Mute Left and Right Channels
    { 0x03, 0x11 },
// Set the device into Standby
    { 0x02, 0x10 },
};
